






#Dieses Modul erlaubt die Ausgabe von Text auf einen TFT-Bildschirm (z.B. ILI9341) im Querformat (Landscape) in doppelter Größe
#Es basiert auf dem Bitmapfont
#Wahrscheinlich ist die  font-Datei 'font5x8.bin' auf dem uP fluechtig und muss bei jedem Einschalten neu geladen
# oder mit dem Hilfsprogramm font_to_bin.py neu erzeugt werden.
#In den Kommentaren werden die deutschen Umlaute als chinesische Schriftzeichen angezeigt.

try:
    import ustruct
except ImportError:
    import struct as ustruct


class BitmapFont:

    def __init__(self, width, height, pixel, font_name='font5x8.bin'):
        # Spezifiziert die Zeichnungsflaeche mit Breite und Hoehe und die Pixelfunktion
        # zum Zeichnen einzelner Pixel
        # Eine optionale Funktion dient zum Ueberschreiben des Namens der Font-Binaerdatei,
        # voreingestellt ist 'font5x8.bin'. Die Fontdatei muss voher per Drag-and Drop in den
        # Programmspeicher des ESP32 geladen worden sein.
        # Die Fontdatei hat folgendes Format:
        # Byte 0: Fontzeichenbreite in Pixel
        # Byte 1: Fontzeichenhoehe in Pixel
        # x Bytes in Gruppen zu je 5Byte, jedes Byte spezifiziert eine Spalte des Zeichens
        # Jedes Bit gibt an, ob in der entsprechenden Zeile des Zeichens ein Punkt gesetzt werden soll.
        # x ist die Anzahl aller darstellbarenn ASCII-Zeichen
        
        self._width = width            # Displaybreite
        self._height = height          # Displayhoehe
        self._pixel = pixel            # Pixelprogramm
        self._font_name = font_name    # Font-Name
        

    def init(self):
        # Oeffnet die Font-Datei und ermittelt die Zeichenbreite und die Zeichenhoehe
        # aus den ersten beiden Bytes
        # Es werden hier nur Fonts bis zu 8 Pixel je Zeile unterstuetzt
        self._font = open(self._font_name,'rb')   # Die Font-Datei wird im Modus "Read-Byte" geoeffnet
        self._font_width, self._font_height = ustruct.unpack('BB', self._font.read(2)) #Die beiden ersten Bytes werden als Breite und H鏋歨e 鐪塨ernommen

    def deinit(self):
        # Schliesst die Font-Datei
        self._font.close()

    def __enter__(self):
        self.init()
        return self

    def __exit__(self, exception_type, exception_value, traceback):
        self.deinit()

    def draw_char(self, ch , x, y , *args, **kwargs):
        # Es werden keine Zeichen ausserhalb der angegebenen Zeichenflaeche dargestellt:
        if x <0 or x >= self._width-5  or y <0 or y > self._height-8:
           message="Ausserhalb des Darstellungsbereiches, Abbruch!"
           return (message)
        # Gehe durch jede Spalte des Zeichens:
        for char_x in range(5):
            # Ermittle das Byte fuer die aktuelle Spalte der Fontdaten
            self._font.seek(2 + (ord(ch) * 5) + char_x)       # gehe zur aktuellen Stelle in der Datei
            line = ustruct.unpack('B', self._font.read(1))[0] # Lese ein Byte
            # Gehe durch jede Zeile im Spaltenbyte:
            for char_y in range(8):
                # Zeichne ein Pixel fuer jedes gesetzte Bit:
                if (line >> char_y) & 0x1:
                    self._pixel((x + (char_y-1)*2), (y  - (char_x -1)*2+ 5), *args, **kwargs)  # als args kann z.B die Farbe gesetzt werden
                    self._pixel((x + (char_y-1)*2), (y  -  (char_x -1)*2+ 6), *args, **kwargs)  # als args kann z.B die Farbe gesetzt werden
                    self._pixel((x + (char_y-1)*2+1), (y  -  (char_x -1)*2+ 5), *args, **kwargs)  # als args kann z.B die Farbe gesetzt werden
                    self._pixel((x + (char_y-1)*2+1), (y  -  (char_x -1)*2+ 6), *args, **kwargs)  # als args kann z.B die Farbe gesetzt werden

    def text(self, txt, x, y, *args, **kwargs):
        # Schreibe den angegebenen Text an die gewuenschte Pixelposition:
        for i in range(len(txt)):

          self.draw_char(txt[i], x-12,  y- (i*12), *args, **kwargs)  # V2
    

    def width(self, text):
        # Die Pixelbreite des angegebenen Textes wird zurueckgegeben:
        return len(text) * (self._font_width + 1)
        
    def msg(self, msg):
        # Eine Versions-Meldung
        msg=msg + ' V30e'
        return msg
        
    def fontkontrolle(self, msg):
        # Eine Fehlermeldung
        msg=msg + "  " + str( self._font_width) + "  " + str(self._font_height)
        return msg
        
  

 

  










